/*
 * Decompiled with CFR 0.152.
 */
package me.andrew.healthindicators.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import me.andrew.healthindicators.Config;
import me.andrew.healthindicators.HeartType;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class PlayerEntityRendererMixin
extends class_922<class_742, class_591<class_742>> {
    private static final class_2960 ICONS = new class_2960("textures/gui/icons.png");

    public PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_591<class_742> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="RETURN")})
    public void renderHealth(class_742 abstractClientPlayerEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo ci) {
        if (!Config.getRenderingEnabled()) {
            return;
        }
        if (!PlayerEntityRendererMixin.shouldRenderHeartsForEntity((class_1297)abstractClientPlayerEntity)) {
            return;
        }
        matrixStack.method_22903();
        double d = this.field_4676.method_23168((class_1297)abstractClientPlayerEntity);
        matrixStack.method_46416(0.0f, abstractClientPlayerEntity.method_17682() + 0.5f, 0.0f);
        if (this.method_4055((class_1309)abstractClientPlayerEntity) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)0.25875f, 0.0);
            if (d < 100.0 && abstractClientPlayerEntity.method_7327().method_1189(2) != null) {
                matrixStack.method_22904(0.0, (double)0.25875f, 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        float pixelSize = 0.025f;
        matrixStack.method_22905(pixelSize, pixelSize, pixelSize);
        matrixStack.method_46416(0.0f, (float)Config.getHeartOffset(), 0.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexConsumer = tessellator.method_1349();
        vertexConsumer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
        RenderSystem.enableDepthTest();
        Matrix4f model = matrixStack.method_23760().method_23761();
        int healthRed = class_3532.method_15386((float)abstractClientPlayerEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)abstractClientPlayerEntity.method_6063());
        int healthYellow = class_3532.method_15386((float)abstractClientPlayerEntity.method_6067());
        int heartsRed = class_3532.method_15386((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = Config.getHeartStackingEnabled() ? 10 : heartsTotal;
        int rowsTotal = (heartsTotal + heartsPerRow - 1) / heartsPerRow;
        int rowOffset = Math.max(10 - (rowsTotal - 2), 3);
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        for (int heart = 0; heart < heartsTotal; ++heart) {
            HeartType type;
            int row = heart / heartsPerRow;
            int col = heart % heartsPerRow;
            float x = maxX - (float)(col * 8);
            float y = row * rowOffset;
            float z = (float)row * 0.01f;
            PlayerEntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, y, z, HeartType.EMPTY);
            if (heart < heartsRed) {
                type = HeartType.RED_FULL;
                if (heart == heartsRed - 1 && lastRedHalf) {
                    type = HeartType.RED_HALF;
                }
            } else if (heart < heartsNormal) {
                type = HeartType.EMPTY;
            } else {
                type = HeartType.YELLOW_FULL;
                if (heart == heartsTotal - 1 && lastYellowHalf) {
                    type = HeartType.YELLOW_HALF;
                }
            }
            if (type == HeartType.EMPTY) continue;
            PlayerEntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, y, z, type);
        }
        tessellator.method_1350();
        matrixStack.method_22909();
    }

    private static boolean shouldRenderHeartsForEntity(class_1297 entity) {
        if (entity instanceof class_742) {
            class_742 abstractClientPlayerEntity = (class_742)entity;
            return !abstractClientPlayerEntity.method_7340() && !abstractClientPlayerEntity.method_5756((class_1657)class_310.method_1551().field_1724);
        }
        return false;
    }

    private static void drawHeart(Matrix4f model, class_4588 vertexConsumer, float x, float y, float z, HeartType type) {
        float minU = (float)type.u / 256.0f;
        float maxU = minU + 0.03515625f;
        float minV = (float)type.v / 256.0f;
        float maxV = minV + 0.03515625f;
        float heartSize = 9.0f;
        PlayerEntityRendererMixin.drawVertex(model, vertexConsumer, x, y - heartSize, z, minU, maxV);
        PlayerEntityRendererMixin.drawVertex(model, vertexConsumer, x - heartSize, y - heartSize, z, maxU, maxV);
        PlayerEntityRendererMixin.drawVertex(model, vertexConsumer, x - heartSize, y, z, maxU, minV);
        PlayerEntityRendererMixin.drawVertex(model, vertexConsumer, x, y, z, minU, minV);
    }

    private static void drawVertex(Matrix4f model, class_4588 vertices, float x, float y, float z, float u, float v) {
        vertices.method_22918(model, x, y, z).method_22913(u, v).method_1344();
    }
}

